 ; Ŀ
 ;   Bingo - 180 text rotator.                                            
 ;   Copyright 1995 by Rocket Software Ltd.                                
 ;   An Indian word meaning "I am one with the universe."                  
 ; 

 ; Ŀ
 ;   Subroutine Root - text rotator.                                       
 ;   Takes only one argument - Enam, the text entity name, and returns     
 ;   absolutely nothing.                                                   
 ; 
 (DEFUN ROOT (enam / bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur pa)
  (setq entt (entget enam))
 ; Ŀ
 ;   The textbox function returns a list containing the offset of the      
 ;   lower left point of the text from the 10 association point -          
 ;   typically 0,0,0 - and the offset of the upper right point from the    
 ;   ten point.  These are assumining that the text isn't obliqued or      
 ;   rotated, the program must adjust for these itself.  I haven't         
 ;   bothered with obliquing, rotation is allowed.                         
 ; 
  (if (setq bb (textbox entt))
      (progn
          (setq rota (cdr (assoc 50 entt)))
          (setq cc (car bb))                    ; ll offset from 10 of text
          (setq dd (cadr bb))                   ; ur offset from 10 of text
          (setq bheigt (- (cadr dd) (cadr cc)))
          (setq bwidth (- (car dd) (car cc)))
          (setq llangg (angle (list 0 0) cc))
          (setq lldist (distance (list 0 0) cc))
          (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
          (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
          (setq lr (polar ll rota bwidth))
          (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   It appears that we now have the real upper left, upper right, etc.    
 ;   points of the text.  This could probably be simplified but since      
 ;   the code is already written...                                        
 ;   Now need the centre point of the text about which to rotate it.       
 ; 
          (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
          (command "rotate" enam "" pa "180")))
 (princ))
 ; Ŀ
 ;   Root end.                                                             
 ; 

 ; Ŀ
 ;   Bingo - the central planning committee.                               
 ; 
 (DEFUN C:BINGO (/ ss len num enam)
  (setvar "cmdecho" 0)
  (write-line "Select text to rotate: ")
  (setq ss (ssget (list (cons 0 "TEXT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (root enam))
 (princ))